#include <iostream>
using namespace std;

// Napomena: U Microsoft Visual C++ kompajlira se kao 
//           cl razlomak6.cpp

class Razlomak {
private:
    int num, den;      // Brojilac i imanilac.
public:
    Razlomak() {set(0, 1);}
    Razlomak(int n, int d) {set(n, d);}
    Razlomak(const Razlomak &src);

    void set(int n, int d) {num = n; den = d; normalize();}
    int get_num() const {return num;}
    int get_den() const {return den;}
    Razlomak add(const Razlomak &other);
    Razlomak mult(const Razlomak &other);
    Razlomak operator+(const Razlomak &other)
        {return add(other);}
    Razlomak operator*(const Razlomak &other)
        {return mult(other);}

private:
    void normalize();   // Konvertovanje u standardni oblik.
    int gcf(int a, int b);     // Najveci zajednicki delilac.
    int lcm(int a, int b);     // Najmanji zajednicki sadryalac.
};

int main() {
    Razlomak f1(1, 2);
    Razlomak f2(1, 3);

    Razlomak f3 = f1 + f2;

    cout << "1/2 + 1/3 = ";
    cout << f3.get_num() << "/";
    cout << f3.get_den() << "." << endl;
    system("PAUSE");
    return 0;
}

// ---------------------------------------------------
// FUNKCIJE KLASE Razlomak 

Razlomak::Razlomak(Razlomak const &src) {
     num = src.num;
     den = src.den;
}

// Normalize: Prevodi raylomak u standardni oblik,
//  jedinstven za svaku matematicki razlicitu vrednost.
//
void Razlomak::normalize(){

    // Slucajevbi sa nulom

    if (den == 0 || num == 0) {
        num = 0;
        den = 1;
    }

    // Postavljanje negativnog znaka samo u brojilac .

    if (den < 0) {
        num *= -1;
        den *= -1;
    }

    // Izdavanje cinioca iz brojioca i imenioca.

    int n = gcf(num, den);
    num = num / n;
    den = den / n;
}

// Najveci zajednicki delilac
//
int Razlomak::gcf(int a, int b) {
    if (a % b == 0)
        return abs(b);
    else
        return gcf(b, a % b);
}

// Najmanji zajednicki sadrzalac
//
int Razlomak::lcm(int a, int b){
    return (a / gcf(a, b)) * b;
}

Razlomak Razlomak::add(const Razlomak &other) {
    Razlomak raz;
    int lcd = lcm(den, other.den);
    int quot1 = lcd/den;
    int quot2 = lcd/other.den;
    raz.set(num * quot1 + other.num * quot2, lcd);
    raz.normalize();
    return raz;
}

Razlomak Razlomak::mult(const Razlomak &other) {
    Razlomak raz;
    raz.set(num * other.num, den * other.den);
    raz.normalize();
    return raz;
}
